//
//  NSUserDefaults+Gensee.h
//  Webcast
//
//  Created by Gaojin Hsu on 11/25/15.
//  Copyright © 2015 Geensee. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSUserDefaults (Gensee)

- (void)saveDomain:(NSString*)domain roomNumber:(NSString*)roomNumber loginName:(NSString*)loginName;

- (NSArray*)fetchDomains;

- (NSString*)fetchRoomNumberWithDomain:(NSString*)domain;

- (NSString*)fetchLoginNameWithDomain:(NSString*)domain;

- (void)saveBroadcastName:(NSString*)name;

- (NSString*)fetchBroadcastName;

- (void)saveBroadcastStatus:(int)status;

- (int)fetchBroadcastStatus;

- (void)saveWifiConfig:(BOOL)allow3G;

- (BOOL)fetchWifiCongfig;

- (void)saveWebUrl:(NSString*)url;

- (NSString*)fetchWebUrl;

- (void)clean;



- (void)saveCurrentOrientation:(NSInteger)Orientation;


- (NSInteger)fetchCurrentOrientation;



- (void)saveCurrentLiveIsActive:(BOOL)active;


- (BOOL)fetchCurrentLiveIsActive;






- (void)saveCurrentCameaStatus:(BOOL)isClosed;
- (BOOL)fetchCurrentCameaStatus;



- (void)saveCurrentMicStatus:(BOOL)isClosed;
- (BOOL)fetchCurrentMicStatus;


- (void)saveCurrentVideoSelfActived:(BOOL)isClosed;
- (BOOL)fetchCurrentVideoSelfActived;




- (void)saveIsCannotCaptureOutPut:(BOOL)IsCan;

- (BOOL)fetchIsCannotCaptureOutPut;



- (void)saveLiveModel:(int)status;
- (int)fetchLiveModel;


- (void)saveQualityType:(graphicsQualityType)type;

- (graphicsQualityType)fetchQualityType;


- (void)saveLiveParamWith:(NSDictionary *)dic;
- (NSDictionary *)getLiveParamWithKeys:(NSArray *)keyArr;


//保存是否自动发布qa配置项数据
- (void)saveIsbAutoPublishQA:(BOOL)isbAutoPublish;
- (BOOL)fetchIsbAutoPublishQA;


//保存视频文档模式下裁剪模式配置项数据
- (void)saveVideoDocCropMode:(GSCropMode)cropMode;
- (int)fetchVideoDocCropMode;



@end
